<?php defined('SYSPATH') or die('No direct script access.');

class Task_Parser_Perl extends Minion_Task{
    protected function _execute(array $params)
    {
        $limit = 10000;
        $offset = 0;
        do {
            $query = DB::select('t.client', 'l.host', 'l.post', 'l.referrer', 'l.link', 'l.datetime', 'l.data')
                ->from(['logpost', 'l'])
                ->join(['test', 't'])
                ->on('l.test_id', '=', 't.id')
                ->where_open()
                    ->where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), '=', 5)
                    ->or_where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), '=', 6)
                ->where_close()
                ->limit($limit)
                ->offset($offset)
                ->execute()
                ->as_array();

            foreach($query as $offset_key => $item){
                $full_name_file = '/home/perl/'.($offset + $offset_key).'.csv';
//                $full_name_file = '/home/parser/'.($offset_key).'.csv';
                $tmp_array = array();
                foreach($item as $key => $item2){
                    if($key != 'data'){
                        $tmp_array[] = $item2;
                    }else{
                        $data_string = '';
                        $data = json_decode($item2, true);
                        foreach($data as $k => $d){
                            $data_string .= $k.": ".$d."\n\r";
                        }
                        $tmp_array[] = $data_string;
                    }
                }
                $fp = fopen($full_name_file, 'w');
                fputcsv($fp, $tmp_array);
                fclose($fp);
                exec('perl /home/perl/perl.pl '.$full_name_file);
                if(!file_exists($full_name_file.'.processed')){
                    unlink($full_name_file);
                }
//                if(file_exists($full_name_file.'.processed')){
//                    unlink($full_name_file.'.processed');
//                }else{
//                    unlink($full_name_file);
//                }
            }

            $offset += $limit;
        }while(!empty($query));

        $csv = glob('/home/perl/*.csv', GLOB_BRACE);
        foreach($csv as $c){
            file_put_contents('/home/result_1.csv', file_get_contents($c), FILE_APPEND);
        }

        $file = glob('/home/perl/*.processed', GLOB_BRACE);
        foreach($file as $f){
            file_put_contents('/home/result_1.processed', file_get_contents($f), FILE_APPEND);
            unlink($f);
        }
    }
}